package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestRoleDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {

		try {
			DartObjectFactory.getInstance().getRoleDAO().findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<Role> roleList = DartObjectFactory.getInstance().getRoleDAO().listAll();
		 
		Assert.assertNotNull(roleList);
		Assert.assertTrue(roleList.size() > 0);
		 
	}

	@Test
	public void testThree() throws Exception {

		try {
			DartObjectFactory.getInstance().getRoleDAO().findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		
		// find somebody to search for
		List<Role> roleList = DartObjectFactory.getInstance().getRoleDAO().listAll();
		 
		Assert.assertNotNull(roleList);
		Assert.assertTrue(roleList.size() > 0);

		Role role1 = roleList.get(0);
		Assert.assertNotNull(role1);
		Assert.assertTrue(role1.getId() > 0);
		
		Role role2 = DartObjectFactory.getInstance().getRoleDAO().findById(role1.getId());
		Assert.assertNotNull(role2);
		Assert.assertEquals(role2, role1);
	}
}
